<?php
/* Template Name: Pat - Options */

get_header();

$container   = get_theme_mod( 'understrap_container_type' );

?>

<div class="wrapper" id="page-wrapper">

	<div id="content" tabindex="-1">



			<div class="content-area" id="primary">

				<main class="site-main" id="main">

					<?php while ( have_posts() ) : the_post(); ?>

						<article <?php post_class(); ?> id="post-<?php the_ID(); ?>">

							<header class="page-header">
								<div class="line"></div>
								<div class="header-wrapper">
									<?php the_title( '<h1 class="page-title">', '</h1>' ); ?>
								</div>


							</header><!-- .entry-header -->

							<?php echo get_the_post_thumbnail( $post->ID, 'large' ); ?>

							<div class="page-content  <?php echo esc_attr( $container ); ?>">

								<?php the_content(); ?>
								<div id="entry-form-content-wrapper">
									<div class="row">
										<div class="col-md-12 col-lg-8">
											<div class="row options-buttons">
												<?php
													$options_pages = array(
														11 => 'fas fa-map-marker-alt',
														23 => 'fab fa-readme',
														26 => 'fas fa-search',
														28 => 'fas fa-pills');
													foreach ($options_pages as $option_page_id => $icon){
														?>
														<div class="col-md-12 col-lg-6">
															<?php
															$current_page= array();
															$current_page['id'] 		= icl_object_id($option_page_id, 'page', false, ICL_LANGUAGE_CODE);
															$current_page['title'] 	= get_the_title($current_page['id']);
															$current_page['link'] 	= get_permalink($current_page['id']);

															?>
															<a href="<?php echo $current_page['link'];?>"><i class="<?php echo $icon;?>"></i><?php echo $current_page['title'];?></a>
														</div>
													<?php
													}
												?>
												<div class="col-md-12 col-lg-8 offset-lg-2 offset-xl-2 ">
													<?php
													$current_page= array();
													$current_page['id'] 		= icl_object_id(62, 'page', false, ICL_LANGUAGE_CODE);
													$current_page['title'] 	= get_the_title($current_page['id']);
													$current_page['link'] 	= get_permalink($current_page['id']);
													?>
													<a href="<?php echo $current_page['link'];?>" class="dark-button"><i class="fas fa-clipboard-list"></i><?php echo $current_page['title'];?></a>
												</div>
											</div>

										</div>
										<div class="col-md-4 d-none d-md-none d-lg-block">
											<div class="girl-wrapper">
												<img src="<?php echo get_stylesheet_directory_uri(); ?>/images/pregnant-girl-01.svg" class="girl" border="0">
											</div>
										</div>
									</div>
								</div>
								<div class="clearfix"></div>


							</div><!-- .entry-content -->

						</article><!-- #post-## -->


					<?php endwhile; // end of the loop. ?>

				</main><!-- #main -->

		</div><!-- .row -->

	</div><!-- Container end -->

</div><!-- Wrapper end -->

<?php get_footer(); ?>
