<?php 
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
if( ! class_exists( 'WP_List_Table' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}
class Orders_Report_List_Table extends WP_List_Table {
    
    /* Retrieve data, Connection with database*/
    private function table_data()
    {
        // Check connection
        if (mysqli_connect_errno())
        {
            echo "Failed to connect to MySQL: " . mysqli_connect_error();
            exit();
        }
        
        require_once(ABSPATH . 'wp-config.php');
        $con=mysqli_connect(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
        
        $data = array();
        
        global $woocommerce;
        $filters = array(
            'post_status' => 'completed',
            'post_type' => 'shop_order',
            'posts_per_page' => -1,
        );
        $loop = new WP_Query($filters);
        
        while ($loop->have_posts()) {
            $loop->the_post();
            $order = new WC_Order($loop->post->ID);
            $items = $order->get_items();
            //var_dump($order);
            $order_id = $order->get_order_number(); 
            $order = wc_get_order( $order_id );
            $airFlight = get_post_meta( $order_id, 'by_air_name', true );
            $shipName = get_post_meta( $order_id, 'on_ship_name', true );

            $order_data = $order->get_data(); // The Order data
          //  var_dump($order_data['line_items']);
            foreach ($order->get_items() as $item_id => $item):
                 $item_data = $item->get_data();
                //echo '<pre>'; print_r($item_data); echo '</pre>';
                
                 $product_title= $item_data['name'];
                
                 $item_meta_data = $item->get_meta_data();
                 foreach ($item_meta_data as $obj){
                    // echo $obj->key;
                     $key = $obj->key;
                     switch ($key) {
                         case 'Journey type':
                             $journeyType = $obj->value;
                             break;
                         case 'Pick up location':
                             $pickupLocation = $obj->value;
                             break;
                         case 'Drop off location':
                             $dropoffLocation = $obj->value;
                             break;
                         case 'Pick up date and time':
                             $pickupDateTime = $obj->value;
                             break;
                         case 'Luggages':
                             $luggages = $obj->value;
                             break;
                         case 'Baby seats':
                             $seats = $obj->value;
                             break;
                     }
                 }
     
            endforeach;
            if($_REQUEST['hotel'] && $_REQUEST['hotel'] != 'all'){ //REFACTOR
                if($pickupLocation == $_REQUEST['hotel'] || $dropoffLocation == $_REQUEST['hotel']){
                    $data[] = array(
                        'OrderNo'          => '#'.$order_id,
                        'Date-Time'  		=> $order_data['date_created']->date('d/m/Y H:i'),
                        'FullName'        => $order_data['billing']['first_name'].' '.$order_data['billing']['last_name'],
                        'Customer-number'        => $order_data['billing']['phone'],
                        'E-mail' => $order_data['billing']['email'],
                        'Product' => $product_title,
                        'Journey-Type' => $journeyType,
                        'Pick-Up-Loc' => $pickupLocation,
                        'Drop-Off-Loc' => $dropoffLocation,
                        'Pick-Up-Fdate' => $pickupDateTime,
                        'Lug-seats' => $luggages.' Lugs & '.$seats.' Seats',
                        'Price' => $order_total_tax = $order_data['total'].'€',
                        'payment-method' => $order_data['payment_method_title'],
                        'flight-ship-name' => $shipName . $airFlight
                    );
                }
            }else{
                if( current_user_can('administrator') || current_user_can('museum-hotels-all')){
                    $data[] = array(
                        'OrderNo'          => '#'.$order_id,
                        'Date-Time'  		=> $order_data['date_created']->date('d/m/Y H:i'),
                        'FullName'        => $order_data['billing']['first_name'].' '.$order_data['billing']['last_name'],
                        'Customer-number'        => $order_data['billing']['phone'],
                        'E-mail' => $order_data['billing']['email'],
                        'Product' => $product_title,
                        'Journey-Type' => $journeyType,
                        'Pick-Up-Loc' => $pickupLocation,
                        'Drop-Off-Loc' => $dropoffLocation,
                        'Pick-Up-Fdate' => $pickupDateTime,
                        'Lug-seats' => $luggages.' Lugs & '.$seats.' Seats',
                        'Price' => $order_total_tax = $order_data['total'].'€',
                        'payment-method' => $order_data['payment_method_title'],
                        'flight-ship-name' => $shipName . $airFlight
                    );
                }else{
//                    if(current_user_can('electra-palace-user') ) {
//                        $uniqueHotel= 'Electra Palace';
//                    }
                    if(current_user_can('museum-athens-user') ) {
                        $uniqueHotel= 'Museum Hotel';
                    }
//                    if(current_user_can('electra-metropolis-user') ) {
//                        $uniqueHotel= 'Electra Metropolis';
//                    }
                    if($pickupLocation == $uniqueHotel || $dropoffLocation == $uniqueHotel){
                        $data[] = array(
                            'OrderNo'          => '#'.$order_id,
                            'Date-Time'  		=> $order_data['date_created']->date('d/m/Y H:i'),
                            'FullName'        => $order_data['billing']['first_name'].' '.$order_data['billing']['last_name'],
                            'Customer-number'        => $order_data['billing']['phone'],
                            'E-mail' => $order_data['billing']['email'],
                            'Product' => $product_title,
                            'Journey-Type' => $journeyType,
                            'Pick-Up-Loc' => $pickupLocation,
                            'Drop-Off-Loc' => $dropoffLocation,
                            'Pick-Up-Fdate' => $pickupDateTime,
                            'Lug-seats' => $luggages.' Lugs & '.$seats.' Seats',
                            'Price' => $order_total_tax = $order_data['total'].'€',
                            'payment-method' => $order_data['payment_method_title'],
                            'flight-ship-name' => $shipName . $airFlight
                        );
                    }
                    
                }
            }
        
            
        }
        
        return $data;
        $con->close();
     
    }
    
    
    
    function get_columns(){
        
        $columns = array(
           // 'cb'        => '<input type="checkbox" />', //add checkboxes for bulk actions
            'OrderNo'   	=> 'Order No',
            'Date-Time'     => 'Date & Time',
            'FullName'     =>   'FullName',
            'Customer-number' => 'Customer Number',
            'E-mail' => 'E-mail',
            'Product' => 'Product',
            'Journey-Type' => 'Journey Type',
            'Pick-Up-Loc' => 'Pick Up Location',
            'Drop-Off-Loc' => 'Drop Off Location',
            'Pick-Up-Fdate' => 'Pick Up Date',
            'Lug-seats' => 'Lugguages & Seats',
            'Price' => 'Price',
            'payment-method' => 'Payment Method',
            'flight-ship-name' => 'Flight or Ship Name'
            
        );
        
        return $columns;
    }
    function column_default( $item, $column_name ) {
        switch( $column_name ) {
            case 'OrderNo':
            case 'Date-Time':
            case 'FullName':
            case 'Customer-number':
            case 'E-mail':
            case 'Product':
            case 'Journey-Type':
            case 'Pick-Up-Loc':
            case 'Drop-Off-Loc':
            case 'Pick-Up-Fdate':
            case 'Lug-seats':
            case 'Price':
            case 'payment-method':
            case 'flight-ship-name':
                //case 'rating':
                return $item[ $column_name ];
            default:
                return print_r( $item, true ) ; //Show the whole array for troubleshooting purposes
        }
    }
    
    
    
    /* Styling the table */
    function __construct(){
        global $status, $page;
        parent::__construct( array(
            'singular'  => __( 'order', 'mylisttable' ),     //singular name of the listed records
            'plural'    => __( 'orders', 'mylisttable' ),   //plural name of the listed records
            'ajax'      => false        //does this table support ajax?
        ) );
        //add_action( 'admin_head', array( &$this, 'admin_header' ) );

    }

    /* No results message */
     function no_items() {
         _e( 'No results found.' );
     }
     
     
     /* Edit & delete choices */
     /*function column_booktitle($item){
      $actions = array(
      'edit'      => sprintf('<a href="?page=%s&action=%s&book=%s">Edit</a>',$_REQUEST['page'],'edit',$item['ID']),
      'delete'    => sprintf('<a href="?page=%s&action=%s&book=%s">Delete</a>',$_REQUEST['page'],'delete',$item['ID']),
      );
      return sprintf('%1$s %2$s', $item['booktitle'], $this->row_actions($actions) );
      }*/
     
     /* // Bulk Actions dropdown menu
      function get_bulk_actions() {
      $actions = array(
      'delete'    => 'Delete'
      );
      return $actions;
      }*/
     // add checkbox function
//      function column_cb($item) {
//       return sprintf(
//       '<input type="checkbox" name="order[]" value="%s" />', $item['OrderNo']
//       );
//       }
     
     /* functions for sorting */////
     /*function get_sortable_columns() {
         $sortable_columns = array(
             //'Last_Activity' => array('Last_Activity',false),
             'OrderNo' => array('OrderNo',false)
         );
         return $sortable_columns;
     }*/
    /* private function sort_data( $a, $b )
     {
         // Set defaults
         $orderby = 'OrderNo';
         $order = 'desc';
         // If orderby is set, use this as the sort column
         if(!empty($_GET['orderby']))
         {
             $orderby = $_GET['orderby'];
         }
         // If order is set use this as the order
         if(!empty($_GET['order']))
         {
             $order = $_GET['order'];
         }
         $result = strcmp( $a[$orderby], $b[$orderby] );
         if($order === 'asc')
         {
             return $result;
         }
         return -$result;
     }*/
     
     function prepare_items($search ='') {
         $columns = $this->get_columns();
         $hidden = $this->get_hidden_columns();
         $sortable = $this->get_sortable_columns();
         if( $search != NULL ){
             $search = trim($search);
             //$data = $this->table_data($search);
         }else{
             //$data = $this->table_data();
         }
         $data = $this->table_data($search);
         //usort( $data, array( &$this, 'sort_data' ) );
         $perPage = 20;
         $currentPage = $this->get_pagenum();
         $totalItems = count($data);
         $this->set_pagination_args( array(
             'total_items' => $totalItems,
             'per_page'    => $perPage
         ) );
         $data = array_slice($data,(($currentPage-1)*$perPage),$perPage);
         $this->_column_headers = array($columns, $hidden, $sortable);
         $this->items = $data;
         
     }
     
     function download(){
         $filename = 'hotels-orders-' . time() . '.csv';
         $header_row = array(
             'OrderNo',
              'Date & Time',
               'FullName',
              'Customer Number',
              'E-mail',
              'Product',
              'Journey Type',
              'Pick Up Location',
             'Drop Off Location',
              'Pick Up Date',
              'Lugguages & Seats',
              'Price',
              'Payment Method',
              'Flight or Ship Name'
         );
         ob_end_clean();
         $data_rows = $this->table_data();
        //var_dump($data_rows);
         $fh = @fopen( 'php://output', 'w' );
         fprintf( $fh, chr(0xEF) . chr(0xBB) . chr(0xBF) );
         header( 'Cache-Control: must-revalidate, post-check=0, pre-check=0' );
         header( 'Content-Description: File Transfer' );
         header( 'Content-type: text/csv' );
         header( "Content-Disposition: attachment; filename={$filename}" );
         header( 'Expires: 0' );
         header( 'Pragma: public' );
         fputcsv( $fh, $header_row );
         foreach ( $data_rows as $data_row ) {
             fputcsv( $fh, $data_row );
         }
         fclose( $fh );
         die();
     }
     
} // class

?>
